import { IDiscipline } from "./discipline.interface";

export interface IDisciplineRepository {
    createDiscipline (
        disciplineData: IDiscipline
    ): Promise<IDiscipline>;

    findDisciplineById (
        id: string
    ): Promise<IDiscipline | null>;

    findDisciplineByName (
        name: string
    ): Promise<IDiscipline | null>;

    listDisciplines (
        filter: Partial<IDiscipline>
    ): Promise<IDiscipline[]>;

    updateDisciplineById (
        id: string,
        disciplineData: Partial<IDiscipline>
    ): Promise<IDiscipline | null>;

    deleteDisciplineById (
        id: string
    ): Promise<IDiscipline | null>;
}