import { ICategory } from "../../Category/interfaces/category.interface";
import { IDiscipline } from "./discipline.interface";
import { IDisciplineRepository } from "./discipline.repository.interface";

export interface IParamsDisciplineService {
    repository: IDisciplineRepository;
}

export interface IParamsCreateDiscipline {
    name: string;
    description: string;
    category_id: string;
}

export interface IParamsUpdateDiscipline {
    id: string;
    data: Partial<IDiscipline>;
}

export type IGetCategoryById = (id: string) => Promise<ICategory>;

export interface IDisciplineService {
    createDiscipline(
        params: IParamsCreateDiscipline,
    ): Promise<IDiscipline>;

    getDisciplineById(
        id: string,
    ): Promise<IDiscipline | null>;

    listDisciplines(
        filter: object
    ): Promise<IDiscipline[]>;

    updateDisciplineById(
        params: IParamsUpdateDiscipline
    ): Promise<IDiscipline | null>;

    deleteDisciplineById(
        id: string
    ): Promise<IDiscipline | null>;
}