import { Document } from "mongoose";

/**
 * Interface representing the structure of a role object
 * used across the application.
 */
export interface IRole {
    id?: string;
    name: string;
    description: string;
    created_at?: Date;
    updated_at?: Date;
}

/**
 * Interface for MongoDB-specific role fields
 */
export interface IMRole extends Document {
    _id: string;
    name: string;
    description: string;
    created_at?: Date;
    updated_at?: Date;
    __v?: number;
}