import { IRole } from "./roles.interface";

export interface IRoleRepository {

    createRole(
        roleData: IRole
    ): Promise<IRole>;

    findRoleById(
        id: string
    ): Promise<IRole | null>;

    findRoleByName(
        name: string
    ): Promise<IRole | null>;

    listRole(
        filter: object
    ): Promise<IRole[] | []>;

    updateRoleById(
        id: string,
        updateData: Partial<IRole>
    ): Promise<IRole | null>

    deleteRoleById(
        id: string
    ): Promise<IRole | null>;
}