import { IRole } from "./roles.interface";
import { IRoleRepository } from "./roles.repository.interface";

export interface IParamsCreateRole {
    name: string;
    description: string;
}

export interface IParamsUpdateRole {
    id: string;
    data: Partial<IRole>;
}

export interface IParamsRoleService {
    RoleRepository: IRoleRepository;
}

export interface IRoleService {
    createRole(
        params: IParamsCreateRole
    ): Promise<IRole>;

    findRoleById(
        id: string
    ): Promise<IRole>;

    listRoles(
        filter: object
    ): Promise<IRole[]>

    updateRole(
        params: IParamsUpdateRole,
    ): Promise<IRole>

    deleteRole(
        id: string,
    ): Promise<IRole>;
}