import { IRole } from "./interfaces/roles.interface";

/**
 * Role entity representing a role in the system.
 * Contains basic information such as name and description.
 */
export class Role {
    name: string;
    description: string;

    constructor(
        role: IRole
    ) {
        Role.validateRequiredFields(role);

        this.name = role.name;
        this.description = role.description;
    }

    private static validateRequiredFields(
        role: IRole
    ): void {
        const fields: (keyof IRole)[] = [
            'name',
            'description'
        ];

        for (const field of fields) {
            if (!role[field]) {
                throw new AppError(`Missing required field ${field}`, 400);
            }
        }
    }
}