import { Document } from "mongoose";

/**
 * Student interface representing the structure of a student object
 * to use across the application.
 */
export interface IStudent {
    id?: string;
    full_name: string;
    birth_date: Date;
    gender?: string;
    cpf: {
        value: string;
        upload_id?: string;
    };
    rg?: {
        value?: string;
        upload_id?: string;
    };
    email: string;
    password: string;
    telephone: string;
    academic: {
        current_grade: string;
        school?: string;
        subjects: string[];
        difficulty_level: string;
        main_goal: string;
    };
    ranking: number;
    total_classes: number;
    class_preferences: {
        modality: 'online' | 'presencial' | 'hibrida';
        frequency: string;
        available_times: Array<{
            day_of_week: number;
            start_time: number;
            end_time: number;
        }>;
        preferred_teacher?: string;
    };
    guardian?: {
        full_name: string;
        birth_date: Date;
        telephone: string;
        email: string;
        relationship: string;
        cpf: {
            value: string;
            upload_id?: string;
        };
        rg: {
            value: string;
            upload_id?: string;
        };
    };
    financial?: {
        credit_card_registered: boolean;
        card_info?: {
            cardholder_name: string;
            card_number: string;
            expiration: string;
            cvv: string;
        };
    };
    password_reset?: {
        token: string | null;
        expires_at: Date | null;
    };
    created_at?: Date;
    updated_at?: Date;
}

/**
 * Student interface for MongoDB specific fields
 */
export interface IMStudent extends Document {
    _id: string;
    full_name: string;
    birth_date: Date;
    gender?: string;
    cpf: {
        value: string;
        upload_id?: string;
    };
    rg?: {
        value?: string;
        upload_id?: string;
    };
    email: string;
    password: string;
    password_reset?: {
        token?: string;
        expires_at?: Date;
    }
    telephone: string;
    academic: {
        current_grade: string;
        school?: string;
        subjects: string[];
        difficulty_level: string;
        main_goal: string;
    };
    ranking: number;
    total_classes: number;
    class_preferences: {
        modality: 'online' | 'presencial' | 'hibrida';
        frequency: string;
        available_times: Array<{
            day_of_week: number;
            start_time: number;
            end_time: number;
        }>;
        preferred_teacher?: string;
    };
    guardian?: {
        full_name: string;
        birth_date: Date;
        telephone: string;
        email: string;
        relationship: string;
        cpf: {
            value: string;
            upload_id?: string;
        };
        rg: {
            value: string;
            upload_id?: string;
        };
    };
    financial?: {
        credit_card_registered: boolean;
        card_info?: {
            cardholder_name: string;
            card_number: string;
            expiration: string;
            cvv: string;
        };
    };
    created_at: Date;
    updated_at: Date;
}