import { IStudent } from "./student.interface";

export interface IStudentRepository {
    createStudent(
        student: IStudent
    ): Promise<IStudent>;

    getStudentById(
        id: string
    ): Promise<IStudent | null>;

    getStudentByEmail(
        email: string
    ): Promise<IStudent | null>;

    listStudents(
        filter: object
    ): Promise<IStudent[] | []>;

    updateStudent(
        id: string,
        data: Partial<IStudent>
    ): Promise<IStudent | null>;

    deleteStudent(
        id: string
    ): Promise<IStudent | null>;
}