import { IStudentRepository } from "./student.repository.interface";
import { IStudent } from "./student.interface";
import { IFilteredTeacher, IFindTeacherFilter } from "../../Teacher/interfaces/teacher.service.interface";
import { IClass } from "../../Class/interfaces/class.interface";
import { IParamsCreateClass } from "../../Class/interfaces/class.service.interface";

export interface IParamsCreateStudent {
    full_name: string;
    birth_date: Date;
    gender?: string;
    email: string;
    password: string;
    cpf: {
        value: string;
        upload_id?: string;
    };
    rg?: {
        value?: string;
        upload_id?: string;
    };
    telephone: string;
    academic: {
        current_grade: string;
        subjects: string[];
        difficulty_level: string;
        main_goal: string;
    };
    class_preferences: {
        modality: 'online' | 'presencial' | 'hibrida';
        frequency: string;
        available_times: Array<{
            day_of_week: number;
            start_time: number;
            end_time: number;
        }>;
    };
    guardian?: {
        full_name: string;
        birth_date: Date;
        telephone: string;
        email: string;
        relationship: string;
        cpf: {
            value: string;
            upload_id?: string;
        };
        rg: {
            value: string;
            upload_id?: string;
        };
    };
    financial?: {
        credit_card_registered: boolean;
        card_info?: {
            cardholder_name: string;
            card_number: string;
            expiration: string;
            cvv: string;
        };
    };
}

export interface IFilterStudent {
    daysOfWeek?: string[] | number[];
    startMinutes?: number;
    endMinutes?: number;
}

export interface IStudentFiltered {
    name: string;
    cpf: string;
    birth_date: Date;
    available_times: Array<{
        day_of_week: number;
        start_time: number;
        end_time: number;
    }>;
}

export interface IParamsUpdateStudent {
    id: string;
    data: Partial<IStudent>
}

export interface IParamsStudentService {
    repository: IStudentRepository;
}

export type IListTeachers = (filter: IFindTeacherFilter) => Promise<IFilteredTeacher[]>;
export type ICreateClass = (params: IParamsCreateClass) => Promise<IClass>;
export type IGetClassById = (id: string) => Promise<IClass>;
export type IListClasses = (filter: object) => Promise<IClass[]>;
export type IUpdateClass = (params: { id: string, data: object }) => Promise<IClass>;
export type ICancelClass = (id: string) => Promise<IClass>;

export interface IStudentService {
    createStudent(
        student: IParamsCreateStudent
    ): Promise<IStudent>;

    getStudentById(
        id: string
    ): Promise<IStudent>;

    listStudents(
        filter?: object
    ): Promise<IStudent[]>;

    listAdaptedStudents(
        filter: IFilterStudent
    ): Promise<IStudentFiltered[]>;

    updateStudent(
        params: IParamsUpdateStudent
    ): Promise<IStudent>;

    deleteStudent(
        id: string
    ): Promise<IStudent>;

    getTeachers: IListTeachers;
    createClass: ICreateClass;
    getClassById: IGetClassById;
    listClasses: IListClasses;
    updateClass: IUpdateClass;
    cancelClass: ICancelClass;
}