import { Document } from "mongoose";

/**
 * Teacher interface representing the structure of a teacher object
 * to use across the application.
 */
export interface ITeacher {
    id?: string;
    full_name: string;
    cpfCnpj: {
        value: string;
        upload_id?: string;
        type: 'CPF' | 'CNPJ';
    };
    rg?: {
        value: string;
        upload_id?: string;
    };
    email: string;
    password: string;
    telephone: string;
    birth_date: Date;
    image_profile?: string;
    address?: {
        street: string;
        number: string;
        complement?: string;
        city: string;
        state: string;
        zip_code: string;
    };
    education?: {
        level: string;
        field: string;
        teaching_experience: string;
        disciplines: string[];
        education_levels: string[];
    };
    availability?: {
        in_person_location: string[];
        available_times: Array<{
            day_of_week: number;
            start_time: number;
            end_time: number;
        }>;
        accepts_emergency_classes: boolean;
    };
    payment?: {
        hourly_rate: number;
        payment_info: {
            type: string;
            key: string;
        };
    };
    preferences?: {
        student_type_preference?: string;
        general_observations?: string;
    };
    password_reset?: {
        token: string | null;
        expires_at: Date | null;
    };
    created_at?: Date;
    updated_at?: Date;
}

/**
 * Teacher interface for MongoDB specific fields
 */
export interface IMTeacher extends Document {
    _id: string;
    full_name: string;
    cpfCnpj: {
        value: string;
        upload_id?: string;
        type: 'CPF' | 'CNPJ';
    };
    rg?: {
        value: string;
        upload_id?: string;
    };
    email: string;
    password: string;
    telephone: string;
    birth_date: Date;
    image_profile?: string;
    address?: {
        street: string;
        number: string;
        complement?: string;
        city: string;
        state: string;
        zip_code: string;
    };
    education?: {
        level: string;
        field: string;
        teaching_experience: string;
        disciplines: string[];
        education_levels: string[];
    };
    availability?: {
        in_person_location: string[];
        available_times: Array<{
            day_of_week: number;
            start_time: number;
            end_time: number;
        }>;
        accepts_emergency_classes: boolean;
    };
    payment?: {
        hourly_rate: number;
        payment_info: {
            type: string;
            key: string;
        };
    };
    preferences?: {
        student_type_preference?: string;
        general_observations?: string;
    };
    password_reset?: {
        token: string | null;
        expires_at: Date | null;
    };
    created_at: Date;
    updated_at: Date;
    __v: number;
}