import { ITeacher } from "./teacher.interface";
import { PipelineStage } from "mongoose";

export interface ITeacherRepository {
    getClassName(): string;

    createTeacher(
        params: ITeacher
    ): Promise <ITeacher>;

    getTeacherById(
        id: string
    ): Promise<ITeacher | null>;

    getTeacherByEmail(
        email: string
    ): Promise<ITeacher | null>;

    listTeachers(
        filter: object
    ): Promise<ITeacher[] | []>;

    findTeachersWithAggregate(
        pipeline: PipelineStage[]
    ): Promise<ITeacher[]>;

    updateTeacherById(
        id: string,
        newTeacher: Partial<ITeacher>,
    ): Promise<ITeacher | null>;

    deleteTeacherById(
        id: string
    ): Promise<ITeacher | null>;
}