import { ITeacherRepository } from "./teacher.repository.interface";
import { ITeacher } from "./teacher.interface";
import { IClass } from "../../Class/interfaces/class.interface";
import { ITopic } from "../../Topic/interfaces/topic.interface";

export interface IClassFilter {
    teacher_id: string;
    start_time?: Date;
    end_time?: Date;
    type?: 'individual' | 'group';
    status?: 'scheduled' | 'canceled' | 'completed';
    payment_status?: 'pending' | 'paid' | 'refunded';
}

export type IListClasses = (filter: IClassFilter) => Promise<IClass[]>;
export type IListTopics = (filter: object) => Promise<ITopic[]>;
export type IGetClassById = (id: string) => Promise<IClass>;
export type IUpdateClassById = (params: { id: string, data: object }) => Promise<IClass>;

export interface IParamsTeacherService {
    repository: ITeacherRepository;
}

export interface IParamsCreateTeacher {
    full_name: string;
    cpfCnpj: {
        value: string;
        upload_id?: string;
        type: 'CPF' | 'CNPJ';
    };
    rg?: {
        value: string;
        upload_id?: string;
    };
    email: string;
    password: string;
    telephone: string;
    birth_date: Date;
    image_profile?: string;
    address?: {
        street: string;
        number: string;
        complement?: string;
        city: string;
        state: string;
        zip_code: string;
    };
    education?: {
        level: string;
        field: string;
        teaching_experience: string;
        disciplines: string[];
        education_levels: string[];
    };
    availability?: {
        in_person_location: string[];
        available_times: Array<{
            day_of_week: number;
            start_time: number;
            end_time: number;
        }>;
        accepts_emergency_classes: boolean;
    };
    payment?: {
        hourly_rate: number;
        payment_info: {
            type: string;
            key: string;
        };
    };
    preferences?: {
        student_type_preference?: string;
        general_observations?: string;
    };
}

export interface IParamsUpdateTeacher {
    id: string;
    data: Partial<ITeacher>;
}

export interface ITeacherService extends IFindTeachersService {
    createTeacher(
        params: IParamsCreateTeacher,
    ): Promise<ITeacher>;

    getTeacherById(
        id: string,
    ): Promise<ITeacher>;

    listTeacher(
        filter?: object
    ): Promise<ITeacher[]>;

    updateTeacherById(
        params: IParamsUpdateTeacher
    ): Promise<ITeacher>;

    deleteTeacherById(
        id: string
    ): Promise<ITeacher>;

    listClasses: IListClasses;
    getClassById: IGetClassById;
    finishClass(id: string): Promise<IClass>;
}

export interface IFilteredTeacher {
    id: string;
    full_name: string;
    email: string;
    telephone: string;
    image_profile?: string;
    disciplines: string[];
    available_times: Array<{
        day_of_week: number;
        start_time: number;
        end_time: number;
    }>;
    level_education: string;
    classes: IClass[];
}

export interface IFindTeacherFilter {
    daysOfWeek?: string[] | number[];
    startMinutes?: number;
    endMinutes?: number;
    disciplineId?: string;
}

export interface IFindTeachersService {
    findTeacherForStudent(
        filter: IFindTeacherFilter
    ): Promise<IFilteredTeacher[]>;
}