import { Document } from "mongoose";

// Valid levels
export type typeLevel = 'EF I' | 'EF II' | 'EM' | 'ES';

/**
 * Topic interface representing the structure of a topic object
 * to use across the application.
 */
export interface ITopic {
    id?: string;
    name: string;
    description: string;
    level: typeLevel;
    discipline_id: string;
    created_at?: Date;
    updated_at?: Date;
};

/**
 * Topic interface for MongoDB specific fields
 */
export interface IMTopic extends Document {
    _id: string;
    name: string;
    description: string;
    level: typeLevel;
    discipline_id: string;
    created_at?: Date;
    updated_at?: Date;
    __v?: number;
}