import { ITopic } from "./topic.interface";

export interface ITopicRepository {
    createTopic (
        topicData: ITopic
    ): Promise<ITopic>;

    findTopicById (
        id: string
    ): Promise<ITopic | null>;

    findTopicByName (
        name: string
    ): Promise<ITopic | null>;

    listTopics (
        filter: Partial<ITopic>
    ): Promise<ITopic[]>;

    updateTopicById (
        id: string,
        topicData: Partial<ITopic>
    ): Promise<ITopic | null>;

    deleteTopicById (
        id: string
    ): Promise<ITopic | null>;
}