import { ITopicRepository } from "./topic.repository.interface";
import { ITopic, typeLevel } from "./topic.interface";
import { IDiscipline } from "../../Discipline/interfaces/discipline.interface";

export interface IParamsTopicService {
    repository: ITopicRepository;
}

export type IGetDisciplineById = (id: string) => Promise<IDiscipline>;

export interface IParamsCreateTopic {
    name: string;
    description: string;
    level: typeLevel;
    discipline_id: string;
}

export interface IParamsUpdateTopic {
    id: string;
    data: Partial<ITopic>;
}

export interface ITopicService {
    createTopic(
        params: IParamsCreateTopic,
    ): Promise<ITopic>;

    getTopicById(
        id: string,
    ): Promise<ITopic>;

    listTopics(
        filter?: object
    ): Promise<ITopic[]>;

    updateTopicById(
        params: IParamsUpdateTopic
    ): Promise<ITopic>;

    deleteTopicById(
        id: string
    ): Promise<ITopic>;
}