import { ITopic, typeLevel } from "./interfaces/topic.interface";

export class Topic {
	name: string;
    description: string;
    level: typeLevel;
    discipline_id: string;

	constructor (
        topic: ITopic
    ) {
        Topic.validateRequiredFields(topic);

        this.name = topic.name;
        this.description = topic.description;
		this.level = topic.level;
		this.discipline_id = topic.discipline_id;
	}

    private static validateRequiredFields(
        topic: ITopic
    ): void {
        const fields: (keyof ITopic)[] = [
            'name',
            'description',
            'level',
            'discipline_id',
        ];

        for (const field of fields) {
            if (!topic[field]) {
                throw new AppError(`Missing required field: ${field}`, 400);
            }
        }
    }
}