/**
 * Base interface for entities that can be authenticated
 * Defines the minimum properties required for authentication
 */
export interface IAuthenticatableEntity {
    id?: string;
    email: string;
    password: string;
    password_reset?: {
        token: string | null;
        expires_at: Date | null;
    };
}

/**
 * Generic interface for JWT payload
 */
export interface IAuthJwtPayload {
    id: string;
    email: string;
    [key: string]: unknown;
}