import { IAuthenticatableEntity } from "./auth.interface";

/**
 * Generic interface for authenticatable entity repositories
 * @template T - Type of entity that extends IAuthenticatableEntity
 */
export interface IAuthRepository<T extends IAuthenticatableEntity> {
    findById(
        id: string
    ): Promise<T | null>;

    findByEmail(
        email: string
    ): Promise<T | null>;

    create(
        params: Partial<T>
    ): Promise<T>;

    update(
        id: string,
        params: Partial<T>
    ): Promise<T | null>;
}