import { Document } from "mongoose";

/**
 * User interface representing the structure of a user object
 * to use across the application.
 */
export interface IUser {
    id?: string;
    name: string;
    email: string;
    password: string;
    roles: string[];
    is_active?: boolean;
    password_reset?: {
        token: string | null;
        expires_at: Date | null;
    };
    email_verified_at?: Date | null;
    created_at?: Date;
    updated_at?: Date;
};

/**
 * Payload interface representing the structure of the user data
 * included in JWT tokens.
 */
export interface IUserPayload {
    id: string;
    name: string;
    email: string;
    is_active?: boolean;
    roles?: string[];
    // Add other fields as necessary
};

/**
 * User interface for MongoDB specific fields
 */
export interface IMUser extends Document {
    _id: string;
    name: string;
    email: string;
    password: string;
    is_active?: boolean;
    email_verified_at?: Date | null;
    created_at?: Date;
    updated_at?: Date;
    password_reset?: {
        token: string | null;
        expires_at: Date | null;
    };
    roles: string[];
    __v?: number;
}