import { IUser } from "./user.interface";

export interface IUserRepository {
    createUser(
        userData: IUser
    ): Promise<IUser>;
    
    findUserByEmail(
        email: string
    ): Promise<IUser | null>;
    
    findUserById(
        id: string
    ): Promise<IUser | null>;
    
    listUsers(
        filter: Partial<IUser>
    ): Promise<IUser[]>;
    
    updateUserById(
        id: string,
        userData: Partial<IUser>
    ): Promise<IUser | null>;

    deleteUserById(
        id: string
    ): Promise<IUser | null>;
}