import { IUserRepository } from './user.repository.interface';
import { IUser } from './user.interface';
import { IRole } from '../../Roles/interfaces/roles.interface';
import { IParamsCreateStudent, IParamsUpdateStudent } from '../../Student/interfaces/student.service.interface';
import { IStudent } from '../../Student/interfaces/student.interface';
import { IParamsCreateTeacher, IParamsUpdateTeacher } from '../../Teacher/interfaces/teacher.service.interface';
import { ITeacher } from '../../Teacher/interfaces/teacher.interface';

export interface IParamsUserService {
    userRepository: IUserRepository;
}

export interface IParamsCreateUser {
    name: string;
    email: string;
    password: string;
}

export interface IParamsUpdateUser {
    id: string;
    userData: Partial<IUser>;
}

export type IListRoles = (filter: object) => Promise<IRole[]>;

export type ICreateStudent = (params: IParamsCreateStudent) => Promise<IStudent>;
export type IGetStudentById = (id: string) => Promise<IStudent>;
export type IListStudents = (filter: object) => Promise<IStudent[]>;
export type IUpdateStudent = (params: IParamsUpdateStudent) => Promise<IStudent>;
export type IDeleteStudent = (id: string) => Promise<IStudent>;

export type ICreateTeacher = (params: IParamsCreateTeacher) => Promise<ITeacher>;
export type IGetTeacherById = (id: string) => Promise<ITeacher>;
export type IListTeachers = (filter: object) => Promise<ITeacher[]>
export type IUpdateTeacher = (params: IParamsUpdateTeacher) => Promise<ITeacher>;
export type IDeleteTeacher = (id: string) => Promise<ITeacher>;

export interface IUserService {
    createUser(
        params: IParamsCreateUser
    ): Promise<IUser>;

    assignRoleToUser(
        userId: string,
        roleIds: string[]
    ): Promise<IUser>;

    getUserById(
        id: string
    ): Promise<IUser>;

    getUserByEmail(
        email: string
    ): Promise<IUser>;

    getRolesFromUserById(
        id: string
    ): Promise<IRole[]>;

    listUsers(
        filter: Partial<IUser>
    ): Promise<IUser[]>;

    updateUserById(
        params: IParamsUpdateUser
    ): Promise<IUser>;

    removeRoleFromUserById(
        userId: string,
        roleIds: string[]
    ): Promise<IUser>;

    deleteUserById(
        id: string
    ): Promise<IUser>;

    createStudent(
        params: IParamsCreateStudent
    ): Promise<IStudent>;

    getStudentById(
        id: string
    ): Promise<IStudent>;
    
    listStudents(
        filter: object
    ): Promise<IStudent[]>;
    
    updateStudent(
        params: IParamsUpdateStudent
    ): Promise<IStudent>;
    
    deleteStudent(
        id: string
    ): Promise<IStudent>;
    
    createTeacher(
        params: IParamsCreateTeacher
    ): Promise<ITeacher>;
    
    getTeacherById(
        id: string
    ): Promise<ITeacher>;
    
    listTeachers(
        filter: object
    ): Promise<ITeacher[]>;
    
    updateTeacher(
        params: IParamsUpdateTeacher
    ): Promise<ITeacher>;
    
    deleteTeacher(
        id: string
    ): Promise<ITeacher>;
}