import { Request, Response, NextFunction } from "express";
import { IRoleService } from "../../modules/Roles/interfaces/roles.service.interface";
import { IRole } from "../../modules/Roles/interfaces/roles.interface";

export function CreatePermissionsMiddleware(
    roleService: IRoleService
) {
    return async (
        req: Request,
        res: Response,
        next: NextFunction,
    ) => {
        const user = req.user;

        if (!user || !user.roles || (user.roles as Array<string>).length === 0) {
            // If user has no roles, they have no permissions
            throw new AppError('User without roles', 403);
        }

        // Create an array of promises to fetch roles in parallel
        const rolesPromises = (user.roles as Array<string>).map(async (roleId) => {
            return await roleService.findRoleById(roleId);
        });

        // Wait for the resolution of all promises, returning only valid ones
        const roles = (await Promise.all(rolesPromises)).filter(Boolean) as IRole[];

        if (roles.length === 0) {
            throw new AppError('User without roles', 403);
        }

        /**
         * Check user roles for each function
        **/

        next();
    }
}