import { MailtrapClient, Mail } from "mailtrap";

export class MailtrapService {
    private token?: string;
    private senderEmail?: string;
    private senderName?: string;
    private client: MailtrapClient;

    constructor() {
        this.token = process.env.MAILTRAP_TOKEN;
        this.senderEmail = process.env.MAILTRAP_SENDER_EMAIL;
        this.senderName = process.env.MAILTRAP_SENDER_NAME;

        if(!this.token || !this.senderEmail || !this.senderName){
            throw new AppError('Environment variables not found', 500);
        }

        // Configure the mailtrap client with a token
        this.client = new MailtrapClient({ token: this.token })
    }

    /**
     * Send a email
     */
    public async sendOneMail(
        content: {
            recipient: string,
            subject: string,
            text: string,
        }
    ): Promise<void> {
        try {
            await this.client.send({
                from: {
                    email: this.senderEmail,
                    name: this.senderName,
                },
                to: [{ email: content.recipient }],
                subject: content.subject,
                text: content.text,
            } as Mail)
        } catch(error) {
            throw new AppError(`Error sending email: ${(error as Error).message}`, 500);
        }
    }
}