/**
 * Application custom error class
 */
export class AppError extends Error {
    public status: number;
    public message: string;

    /**
     * Application custom error class
     * @param message - Error message
     * @param status - Status code
     */
    constructor (
        message: string,
        status: number
    ) {
        super(message);
        this.status = status;
        this.message = message;
    }
}