# Contributing

## To contribute and end up in this [list](https://github.com/podio-community/podio-php/graphs/contributors):

1. Fork it
2. Create your feature branch (`git checkout -b my-new-feature`)
3. Test your changes to the best of your ability
4. Commit your changes (`git commit -am 'Add some feature'`)
5. Push to the branch (`git push origin my-new-feature`)
6. Create a new Pull Request and await a review by at least two maintainers

#### EditorConfig

We use [EditorConfig](https://editorconfig.org) to maintain consistent coding styles between various editors and IDEs.  You can find our settings in the `.editorconfig` file in the root of the project.

## PR review

PRs can be be merged by any member of the [Podio Community](https://github.com/orgs/podio-community) organization, when the following conditions are met:

1. All build checks are passing.
2. At least two members (different than the PR creator) reviewed the PR.
3. All questions/problems are addressed.

## Versioning

Versioning generally follows: https://semver.org/. New versions should be cut as often as neccessary. With each release `CHANGES.md` is updated.

## Feature Requests / Issues

New feature requests can be posted as an [issue](https://github.com/podio-community/podio-php/issues) (please search for similar issues first!). Generally, anyone can work on any issue. If you actively work on an issue, please leave a comment on the issue, to avoid duplicate work. Issues are resolved on a best effort basis. As this project only consists of voluntary contributors, there won't be any timelines (except if you commit yourself to one ;-)).
